﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Graphic.Sample2
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern IntPtr GetDC(IntPtr hWnd);

        [DllImport("gdi32.dll")]
        public static extern bool DeleteDC(IntPtr hDC);

        [DllImport("gdi32.dll")]
        public static extern bool MoveToEx(IntPtr hDC, int x, int y, IntPtr lpPoint);

        [DllImport("gdi32.dll")]
        public static extern bool Arc(IntPtr hDC, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect, int nXStartArc, int nYStartArc, int nXEndArc, int nYEndArc);

        [DllImport("gdi32.dll")]
        public static extern bool ArcTo(IntPtr hDC, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect, int nXStartArc, int nYStartArc, int nXEndArc, int nYEndArc);

        [DllImport("gdi32.dll")]
        public static extern bool AngleArc(IntPtr hDC, int x, int y, uint dwRadius, float eStartAngle, float eSweepAngle);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonDraw_Click(object sender, EventArgs e)
        {
            IntPtr hDC = GetDC(this.Handle);
            Arc(hDC, 10, 10, 200, 200, 25, 25, 280, 280);
            MoveToEx(hDC, 100, 150, IntPtr.Zero);
            ArcTo(hDC, 100, 100, 200, 300, 0, 50, 120, 50);
            MoveToEx(hDC, 100, 100, IntPtr.Zero);
            AngleArc(hDC, 150, 150, 130, 90, 290);
            DeleteDC(hDC);
        }
    }
}